<?php

namespace App\Traits;

use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

trait HasActivityLog
{
    use LogsActivity;

    public function getActivitylogOptions(): LogOptions
    {
        $modelName = class_basename($this);

        return LogOptions::defaults()
            ->logAll()                    // تسجيل جميع الحقول
            ->logOnlyDirty()              // فقط الحقول المتغيرة
            ->dontSubmitEmptyLogs()       // عدم حفظ سجلات فارغة
            ->useLogName(strtolower($modelName))
            ->setDescriptionForEvent(fn(string $eventName) => match ($eventName) {
                'created' => "تم إنشاء {$this->getModelArabicName()}",
                'updated' => "تم تحديث {$this->getModelArabicName()}",
                'deleted' => "تم حذف {$this->getModelArabicName()}",
                default => "تم {$eventName} {$this->getModelArabicName()}"
            });
    }

    protected function getModelArabicName(): string
    {
        return match (get_class($this)) {
            'App\Models\User' => 'المستخدم',
            'App\Models\Client' => 'العميل',
            'App\Models\Branch' => 'الفرع',
            default => 'العنصر'
        };
    }

    // ✅ دالة مساعدة لعرض اسم السجل
    public function getActivityLogNameAttribute(): string
    {
        return $this->name ?? $this->title ?? "#{$this->id}";
    }
}
