<?php

namespace App\Support;

use Illuminate\Support\Arr;

class PermissionsLabel
{
    /**
     * يحوّل مفتاح الصلاحية مثل:
     * bookings.update أو inventory.stock.transfer
     * إلى نص عربي باستخدام lang/ar/permissions.php
     */
    public static function label(string $key): string
    {
        $parts = explode('.', $key);
        $actionKey   = array_pop($parts) ?? '';
        $resourceKey = implode('.', $parts);

        $resources = trans('permissions.resources'); // مصفوفة
        $actions   = trans('permissions.actions');   // مصفوفة

        $resource = Arr::get($resources, $resourceKey, $resourceKey);
        $action   = $actions[$actionKey] ?? $actionKey;

        return trans('permissions.format', [
            'action'   => $action,
            'resource' => $resource,
        ]);
    }
}
