<?php

namespace App\Support;

use App\Models\User;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Auth;

class NotifyAdmins
{
    /**
     * أرسل إشعار قاعدة بيانات لكل المستخدمين ذوي دور admin، مع استثناء المُرسِل إن وُجد.
     */
    public static function send(string $title, ?string $body = null, array $extra = []): void
    {
        $admins = User::role('admin')
            ->when(Auth::id(), fn($q) => $q->whereKeyNot(Auth::id()))
            ->get();

        if ($admins->isEmpty()) {
            return;
        }

        $notification = Notification::make()
            ->title($title)
            ->icon($extra['icon'] ?? 'heroicon-o-bell')
            ->success();

        if ($body) {
            $notification->body($body);
        }

        // لو عندك WebSockets/Echo فعِّل الجلب الفوري:
        $notification->sendToDatabase($admins, isEventDispatched: true);
        // بدون websockets احذف الوسيط الثاني أو اجعله false.
    }
}
