<?php

namespace App\Providers;

use App\Models\PayrollBonus;
use App\Models\PayrollDeduction;
use App\Observers\PayrollBonusObserver;
use App\Observers\PayrollDeductionObserver;
use Carbon\Carbon;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Carbon::setLocale('ar');
        PayrollBonus::observe(PayrollBonusObserver::class);
        PayrollDeduction::observe(PayrollDeductionObserver::class);
    }
}
