<?php

namespace App\Policies;

use App\Models\ProductDesign;
use App\Models\User;

class ProductDesignPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(?User $user, ProductDesign $productDesign): bool
    {
        // Public designs can be viewed by anyone
        if ($productDesign->is_public) {
            return true;
        }

        // Private designs can only be viewed by the owner
        return $user && $user->id === $productDesign->user_id;
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, ProductDesign $productDesign): bool
    {
        return $user->id === $productDesign->user_id;
    }

    public function delete(User $user, ProductDesign $productDesign): bool
    {
        return $user->id === $productDesign->user_id;
    }

    public function restore(User $user, ProductDesign $productDesign): bool
    {
        return $user->id === $productDesign->user_id;
    }

    public function forceDelete(User $user, ProductDesign $productDesign): bool
    {
        return $user->id === $productDesign->user_id;
    }
}
