<?php

namespace App\Observers;

use App\Models\PayrollDeduction;

class PayrollDeductionObserver
{
    public function created(PayrollDeduction $deduction): void
    {
        $deduction->payroll?->recalculate();
    }

    public function updated(PayrollDeduction $deduction): void
    {
        $deduction->payroll?->recalculate();
    }

    public function deleted(PayrollDeduction $deduction): void
    {
        $deduction->payroll?->recalculate();
    }

    public function restored(PayrollDeduction $deduction): void
    {
        $deduction->payroll?->recalculate();
    }

    public function forceDeleted(PayrollDeduction $deduction): void
    {
        $deduction->payroll?->recalculate();
    }
}
