<?php

namespace App\Observers;

use App\Models\PayrollBonus;

class PayrollBonusObserver
{
    public function created(PayrollBonus $bonus): void
    {
        $bonus->payroll?->recalculate();
    }

    public function updated(PayrollBonus $bonus): void
    {
        $bonus->payroll?->recalculate();
    }

    public function deleted(PayrollBonus $bonus): void
    {
        $bonus->payroll?->recalculate();
    }

    public function restored(PayrollBonus $bonus): void
    {
        $bonus->payroll?->recalculate();
    }

    public function forceDeleted(PayrollBonus $bonus): void
    {
        $bonus->payroll?->recalculate();
    }
}
