<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VariantAttributeValue extends Model
{
    use HasFactory;

    protected $table = 'variant_attribute_values';

    public $timestamps = false;

    protected $fillable = [
        'variant_id',
        'attribute_id',
        'attribute_value_id',
        'created_at',
    ];

    protected $casts = [
        'variant_id'         => 'integer',
        'attribute_id'       => 'integer',
        'attribute_value_id' => 'integer',
        'created_at'         => 'datetime',
    ];

    /** العلاقات */

    public function variant(): BelongsTo
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id');
    }

    public function attribute(): BelongsTo
    {
        return $this->belongsTo(Attribute::class, 'attribute_id');
    }

    public function value(): BelongsTo
    {
        return $this->belongsTo(AttributeValue::class, 'attribute_value_id');
    }

    /** السكوبات */

    public function scopeForVariant($q, int $variantId)
    {
        $table = $this->getTable();

        return $q->where("{$table}.variant_id", $variantId);
    }

    public function scopeForAttribute($q, int $attributeId)
    {
        $table = $this->getTable();

        return $q->where("{$table}.attribute_id", $attributeId);
    }

    public function scopeForValue($q, int $attributeValueId)
    {
        $table = $this->getTable();

        return $q->where("{$table}.attribute_value_id", $attributeValueId);
    }
}
