<?php

namespace App\Models;

use App\Models\PurchaseInvoice;
use Spatie\MediaLibrary\HasMedia;
use App\Models\Concerns\HasBranch;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Supplier extends Model implements HasMedia
{
    use InteractsWithMedia;
    use HasBranch;
    protected $fillable = [
        'branch_id',
        'name',
        'phone',
        'company',
        'address',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    public function purchaseInvoices(): HasMany
    {
        return $this->hasMany(PurchaseInvoice::class);
    }

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('documents');
    }
}
