<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * أسعار شركة الشحن حسب المدينة
 */
class ShippingCompanyRate extends Model
{
    protected $fillable = [
        'shipping_company_id',
        'city_id',
        'fee',
        'cod_fee',
        'estimated_days',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'fee' => 'integer',
            'cod_fee' => 'integer',
            'estimated_days' => 'integer',
            'is_active' => 'boolean',
        ];
    }

    /* ================== العلاقات ================== */

    public function shippingCompany(): BelongsTo
    {
        return $this->belongsTo(ShippingCompany::class);
    }

    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class);
    }

    /* ================== Scopes ================== */

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeForCity($query, int $cityId)
    {
        return $query->where('city_id', $cityId);
    }

    /* ================== Accessors ================== */

    /**
     * إجمالي رسوم الشحن مع COD
     */
    public function getTotalFeeAttribute(): int
    {
        return $this->fee + $this->cod_fee;
    }
}
