<?php

namespace App\Models;

use App\Enums\ShipmentStatus;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * سجل تغييرات حالة الشحنة
 */
class ShipmentStatusHistory extends Model
{
    protected $table = 'shipment_status_history';

    protected $fillable = [
        'shipment_id',
        'status',
        'location',
        'notes',
        'user_id',
        'changed_at',
    ];

    protected function casts(): array
    {
        return [
            'status' => ShipmentStatus::class,
            'changed_at' => 'datetime',
        ];
    }

    /* ================== العلاقات ================== */

    public function shipment(): BelongsTo
    {
        return $this->belongsTo(Shipment::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /* ================== Scopes ================== */

    public function scopeRecent($query)
    {
        return $query->orderBy('changed_at', 'desc');
    }
}
