<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReceiptInvoiceAllocation extends Model
{
    protected $fillable = [
        'client_receipt_id',
        'invoice_type',
        'invoice_id',
        'invoice_number',
        'invoice_date',
        'invoice_total',
        'invoice_remaining_before',
        'paid_amount',
        'invoice_remaining_after',
    ];

    public function receipt()
    {
        return $this->belongsTo(ClientReceipt::class, 'client_receipt_id');
    }
}
