<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PurchaseInvoiceItemVariantAttributeValue extends Model
{
    protected $table = 'purchase_invoice_item_variant_attribute_values';

    protected $fillable = [
        'purchase_invoice_item_variant_id',
        'attribute_id',
        'attribute_value_id',
    ];

    protected $casts = [
        'purchase_invoice_item_variant_id' => 'integer',
        'attribute_id' => 'integer',
        'attribute_value_id' => 'integer',
    ];

    /* =========================
     * العلاقات
     * ========================= */

    public function variantRow(): BelongsTo
    {
        return $this->belongsTo(PurchaseInvoiceItemVariant::class, 'purchase_invoice_item_variant_id');
    }

    public function attribute(): BelongsTo
    {
        return $this->belongsTo(Attribute::class, 'attribute_id');
    }

    public function value(): BelongsTo
    {
        return $this->belongsTo(AttributeValue::class, 'attribute_value_id');
    }
}
