<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PurchaseInvoiceItemVariant extends Model
{
    protected $table = 'purchase_invoice_item_variants';

    protected $fillable = [
        'purchase_invoice_item_id',
        'product_variant_id',
        'options_hash',
        'quantity',
        'barcode',
        'expiry_date',
        'notes',
    ];

    protected $casts = [
        'purchase_invoice_item_id' => 'integer',
        'product_variant_id' => 'integer',
        'quantity' => 'integer',
        'expiry_date' => 'date',
    ];

    /* =========================
     * العلاقات
     * ========================= */

    public function item(): BelongsTo
    {
        return $this->belongsTo(PurchaseInvoiceItem::class, 'purchase_invoice_item_id');
    }

    public function productVariant(): BelongsTo
    {
        return $this->belongsTo(ProductVariant::class, 'product_variant_id');
    }

    public function optionValues(): HasMany
    {
        return $this->hasMany(PurchaseInvoiceItemVariantAttributeValue::class, 'purchase_invoice_item_variant_id');
    }
}
