<?php

namespace App\Models;

use App\Models\Concerns\HasBranch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PayrollDeduction extends Model
{
    use HasBranch, HasFactory;

    protected $fillable = [
        'branch_id',
        'user_id',        // 👈 المستخدم الذي أضاف الخصم
        'employee_id',
        'year',
        'month',
        'amount',
        'reason',
    ];

    protected $casts = [
        'branch_id' => 'integer',
        'user_id' => 'integer',
        'employee_id' => 'integer',
        'year' => 'integer',
        'month' => 'integer',
        'amount' => 'integer',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }
}
