<?php

namespace App\Models;

use App\Models\Concerns\HasBranch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Payroll extends Model
{
    use HasBranch, HasFactory;

    protected $fillable = [
        'branch_id',
        'user_id',
        'payroll_run_id',
        'employee_id',
        'year',
        'month',
        'base_salary',
        'bonuses_total',
        'deductions_total',
        'net_salary',
        'is_paid',
        'paid_at',
    ];

    protected $casts = [
        'branch_id' => 'integer',
        'user_id' => 'integer',
        'payroll_run_id' => 'integer',
        'employee_id' => 'integer',
        'year' => 'integer',
        'month' => 'integer',
        'base_salary' => 'integer',
        'bonuses_total' => 'integer',
        'deductions_total' => 'integer',
        'net_salary' => 'integer',
        'is_paid' => 'boolean',
        'paid_at' => 'datetime',
    ];

    /* =========================
     * العلاقات
     * ========================= */

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    public function payrollRun(): BelongsTo
    {
        return $this->belongsTo(PayrollRun::class);
    }

    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }

    /* =========================
     * Helpers
     * ========================= */

    public function getLabelAttribute(): string
    {
        return sprintf(
            '%04d/%02d - %s',
            $this->year,
            $this->month,
            $this->employee?->name ?? ''
        );
    }
}
