<?php

namespace App\Models;

use App\Models\Receipt;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    protected $fillable = [
        'name',
        'is_active',
    ];
    protected $casts = [
        'is_active' => 'boolean'
    ];

    // علاقات مفيدة لاحقاً
    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
    public function receipts()
    {
        return $this->hasMany(Receipt::class);
    }
}
