<?php

namespace App\Models;

use App\Models\PurchaseInvoice;
use App\Models\SupplierPayment;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PaymentAllocation extends Model
{
    protected $fillable = [
        'supplier_payment_id',
        'purchase_invoice_id',
        'allocated_amount',
    ];

    protected $casts = [
        'allocated_amount' => 'integer',
    ];

    /** ═══════════════════════════════════════════════════════
     *  العلاقات
     * ═══════════════════════════════════════════════════════ */

    public function payment(): BelongsTo
    {
        return $this->belongsTo(SupplierPayment::class, 'supplier_payment_id');
    }

    public function invoice(): BelongsTo
    {
        return $this->belongsTo(PurchaseInvoice::class, 'purchase_invoice_id');
    }

    /** ═══════════════════════════════════════════════════════
     *  السكوبات
     * ═══════════════════════════════════════════════════════ */

    public function scopeForPayment($query, int $paymentId)
    {
        return $query->where('supplier_payment_id', $paymentId);
    }

    public function scopeForInvoice($query, int $invoiceId)
    {
        return $query->where('purchase_invoice_id', $invoiceId);
    }
}
