<?php

namespace App\Models;

use App\Models\User;
use App\Models\Branch;
use App\Models\Employee;
use App\Models\Concerns\HasBranch;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PayGrade extends Model
{
    use HasFactory, HasBranch;

    /** تحميل العلاقة افتراضياً لتفادي N+1 في الجداول */
    protected $with = ['branch'];

    /** الحقول القابلة للتعبئة */
    protected $fillable = [
        'branch_id',        // ID الفروع
        'name',             // المسمى الوظيفي
        'amount',           // الراتب الشهري
        'is_active',        // حالة التفعيل
    ];

    /** الكاستات */
    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'amount'    => 'integer',
        ];
    }

    /** العلاقات */
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function users()
    {
        return $this->hasMany(User::class, 'pay_grade_id');
    }

    public function employees(): HasMany
    {
        return $this->hasMany(Employee::class);
    }

    /** سكوبات */
    public function scopeActive($q)
    {
        return $q->where('is_active', true);
    }

    /** اسم مع الراتب للعرض */
    public function getDisplayNameAttribute(): string
    {
        return sprintf('%s (%s د.ع)', $this->name, number_format($this->amount));
    }
}
