<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * عداد أرقام الطلبات لكل فرع
 */
class OrderCounter extends Model
{
    protected $fillable = [
        'branch_id',
        'current_sequence',
    ];

    protected function casts(): array
    {
        return [
            'current_sequence' => 'integer',
        ];
    }

    /* ================== العلاقات ================== */

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    /* ================== Methods ================== */

    /**
     * الحصول على الرقم التالي
     */
    public function getNextSequence(): int
    {
        $this->increment('current_sequence');

        return $this->current_sequence;
    }
}
