<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ExchangeRate extends Model
{
    protected $fillable = [
        'currency_id',
        'rate',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'rate'      => 'integer',
    ];

    public function currency(): BelongsTo
    {
        return $this->belongsTo(Currency::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    protected static function booted(): void
    {
        // عند الإنشاء: فعِّل السجل الجديد (إن لم يحدد) ثم عطِّل كل السابقين لنفس العملة
        static::creating(function (ExchangeRate $rate) {
            if (is_null($rate->is_active)) {
                $rate->is_active = true;
            }
        });

        static::created(function (ExchangeRate $rate) {
            if ($rate->is_active) {
                static::where('currency_id', $rate->currency_id)
                    ->where('id', '!=', $rate->id)
                    ->update(['is_active' => false]);
            }
        });

        // عند التعديل: إذا جعلته فعالاً، عطّل أي سجل آخر لنفس العملة
        static::updating(function (ExchangeRate $rate) {
            if ($rate->isDirty('is_active') && $rate->is_active) {
                static::where('currency_id', $rate->currency_id)
                    ->where('id', '!=', $rate->id)
                    ->update(['is_active' => false]);
            }
        });
    }
}
