<?php

namespace App\Models;

use App\Enums\ClientReceiptType;
use App\Enums\ReceiptStatus;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientReceipt extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'receipt_number',
        'year',
        'sequence',
        'branch_id',
        'client_id',
        'receipt_type',
        'receipt_date',

        // الحقول المالية
        'total_amount',
        'total_paid',
        'total_remaining',
        'payment_type',
        'payment_details',

        // الربط
        'reference_type',
        'reference_id',
        'reference_number',
        'notes',
        'issued_by',
        'status',
    ];

    protected $casts = [
        'year'          => 'integer',
        'sequence'      => 'integer',
        'total_amount'  => 'integer',
        'total_paid'    => 'integer',
        'total_remaining' => 'integer',
        'receipt_date'  => 'date',
        'receipt_type'  => ClientReceiptType::class,
        'status'        => ReceiptStatus::class,
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'issued_by');
    }
}
