<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClientLedgerEntry extends Model
{
    protected $fillable = [
        'client_id',
        'branch_id',
        'entry_type',
        'reference_number',
        'reference_type',
        'reference_id',
        'debit',
        'credit',
        'balance',
        'entry_date',
        'description',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
