<?php

namespace App\Models;

use App\Models\InstallmentSchedule;
use Illuminate\Database\Eloquent\Model;

class ClientInstallmentPlan extends Model
{
    protected $fillable = [
        'client_id',
        'branch_id',
        'invoice_type',
        'invoice_id',
        'invoice_number',
        'invoice_date',
        'total_amount',
        'down_payment',
        'financed_amount',
        'installment_count',
        'installment_amount',
        'start_date',
        'end_date',
        'status',
        'user_id',
        'notes',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function schedules()
    {
        return $this->hasMany(InstallmentSchedule::class, 'installment_plan_id');
    }
}
