<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClientAccount extends Model
{
    protected $fillable = [
        'client_id',
        'branch_id',
        'receivable_total',
        'receivable_paid',
        'receivable_remaining',
        'payable_total',
        'payable_paid',
        'payable_remaining',
        'client_advance',
        'company_advance',
        'last_transaction_at',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
