<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * عنصر في سلة التسوق
 */
class CartItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'cart_id',
        'product_id',
        'product_variant_id',
        'quantity',
        'unit_price',
    ];

    protected function casts(): array
    {
        return [
            'quantity' => 'integer',
            'unit_price' => 'integer',
        ];
    }

    /* ================== العلاقات ================== */

    public function cart(): BelongsTo
    {
        return $this->belongsTo(Cart::class);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function variant(): BelongsTo
    {
        return $this->belongsTo(ProductVariant::class, 'product_variant_id');
    }

    /* ================== Accessors ================== */

    /**
     * إجمالي السطر
     */
    public function getLineTotalAttribute(): int
    {
        return $this->quantity * $this->unit_price;
    }

    /**
     * هل المنتج متوفر بالكمية المطلوبة؟
     */
    public function getIsAvailableAttribute(): bool
    {
        return $this->variant && $this->variant->total_available >= $this->quantity;
    }
}
