<?php

namespace App\Models;

use App\Models\Concerns\HasBranch;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BranchWarehouse extends Model
{
    use HasBranch;

    protected $table = 'branch_warehouse';

    protected $fillable = [
        'branch_id',
        'warehouse_id',
        'is_primary',
        'assigned_at',
        'unassigned_at',
    ];

    protected $casts = [
        'is_primary'   => 'boolean',
        'assigned_at'   => 'datetime',
        'unassigned_at' => 'datetime',
    ];

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    // تصحيح: يجب أن تكون مفردة
    public function warehouse(): BelongsTo
    {
        return $this->belongsTo(Warehouse::class);
    }
}
