<?php

namespace App\Models;

use App\Models\Concerns\HasBranch;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AdvanceInstallment extends Model
{
    use HasFactory, SoftDeletes, HasBranch;

    protected $table = 'advance_installments';

    protected $fillable = [
        'branch_id',
        'advance_id',
        'payroll_id',
        'user_id',
        'amount',
    ];

    protected $casts = [
        'branch_id'  => 'integer',
        'advance_id' => 'integer',
        'payroll_id' => 'integer',
        'user_id'    => 'integer',
        'amount'     => 'integer',
    ];

    /* =========================
     * العلاقات
     * ========================= */

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    public function advance(): BelongsTo
    {
        return $this->belongsTo(EmployeeAdvance::class, 'advance_id');
    }

    public function payroll(): BelongsTo
    {
        return $this->belongsTo(Payroll::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
