<?php

namespace App\Livewire\Store;

use App\Models\Product;
use Livewire\Attributes\Computed;
use Livewire\Component;

class SearchModal extends Component
{
    public string $search = '';

    public function updatedSearch(): void
    {
        // يتم تحديث النتائج تلقائياً عبر computed property
    }

    #[Computed]
    public function searchResults()
    {
        if (strlen(trim($this->search)) < 2) {
            return collect();
        }

        return Product::query()
            ->active()
            ->with(['category', 'brand', 'defaultVariant.prices'])
            ->where(function ($q) {
                $search = $this->search;
                $q->where('name', 'like', "%{$search}%")
                    ->orWhere('description', 'like', "%{$search}%");
            })
            ->latest('id')
            ->limit(8)
            ->get()
            ->map(function ($product) {
                $baseVariant = $product->defaultVariant ?? $product->variants->first();

                // Get price based on client type
                $client = auth('client')->user();
                $priceType = ($client && $client->client_type === 'company') ? 'wholesale' : 'retail';
                $price = $baseVariant?->getPriceForType($priceType) ?? 0;

                return [
                    'id' => $product->id,
                    'name' => $product->name,
                    'slug' => $product->slug,
                    'price' => $price,
                    'image' => $product->thumbnail_url ?? $product->thumbnail_thumb_url,
                    'category' => $product->category?->name,
                    'brand' => $product->brand?->name,
                    'in_stock' => $product->isInStock(),
                ];
            });
    }

    public function render()
    {
        return view('livewire.store.search-modal');
    }
}
