<?php

namespace App\Livewire\Store;

use App\Models\Cart;
use App\Models\Compare;
use App\Models\Wishlist;
use Livewire\Attributes\On;
use Livewire\Component;

class NavbarCounters extends Component
{
    public function getCartCountProperty(): int
    {
        $client = auth('client')->user();
        $sessionId = session()->getId();

        $cart = Cart::query()
            ->active()
            ->when($client, fn ($q) => $q->where('client_id', $client->id))
            ->when(! $client, fn ($q) => $q->where('session_id', $sessionId))
            ->first();

        return $cart ? $cart->items_count : 0;
    }

    public function getWishlistCountProperty(): int
    {
        $client = auth('client')->user();

        if (! $client) {
            return 0;
        }

        return Wishlist::where('client_id', $client->id)->count();
    }

    public function getCompareCountProperty(): int
    {
        $client = auth('client')->user();
        $sessionId = session()->getId();

        return Compare::query()
            ->when($client, fn ($q) => $q->where('client_id', $client->id))
            ->when(! $client, fn ($q) => $q->where('session_id', $sessionId))
            ->count();
    }

    #[On('cart:updated')]
    #[On('wishlist:updated')]
    #[On('compare:updated')]
    public function refresh(): void
    {
        // Triggers re-render
    }

    public function render()
    {
        return view('livewire.store.navbar-counters', [
            'cartCount' => $this->cartCount,
            'wishlistCount' => $this->wishlistCount,
            'compareCount' => $this->compareCount,
        ]);
    }
}
