<?php

namespace App\Livewire\Products;

use App\Models\Product;
use Livewire\Component;

class FeaturedGrid extends Component
{
    public int $limit = 4;

    public function getProductsProperty()
    {
        return Product::query()
            ->where('is_active', true)
            ->latest('id')
            ->take($this->limit)
            ->get();
    }

    public function render()
    {
        return view('livewire.products.featured-grid', [
            'products' => $this->products,
        ]);
    }
}
