<?php

namespace App\Livewire\Auth;

use Livewire\Component;

class VerifyCode extends Component
{
    public string $phone = '';

    public string $code = '';

    public function verify(): void
    {
        $this->validate([
            'phone' => ['required', 'string', 'min:6'],
            'code' => ['required', 'string', 'min:4'],
        ]);

        // لاحقًا: تحقق فعلي من OTP
        session()->flash('success', 'تم التحقق (واجهة فقط حالياً).');
    }

    public function resend(): void
    {
        $this->validate([
            'phone' => ['required', 'string', 'min:6'],
        ]);

        // لاحقًا: إرسال OTP
        session()->flash('success', 'تمت إعادة إرسال رمز التحقق (واجهة فقط حالياً).');
    }

    public function render()
    {
        return view('livewire.auth.verify-code')->layout('layouts.master');
    }
}
