<?php

namespace App\Livewire\Auth;

use App\Models\Client;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;

class ResetPasswordForm extends Component
{
    public string $token = '';

    public string $phone = '';

    public string $password = '';

    public string $password_confirmation = '';

    public function mount(string $token): void
    {
        $this->token = $token;
        $this->phone = (string) request()->query('phone', '');
    }

    public function resetPassword(): void
    {
        $data = $this->validate([
            'token' => ['required', 'string'],
            'phone' => ['required', 'string', 'min:6'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
        ]);

        $row = DB::table('client_password_reset_tokens')
            ->where('phone', trim($data['phone']))
            ->first();

        if (! $row) {
            $this->addError('phone', 'رمز غير صالح أو منتهي.');

            return;
        }

        if (! Hash::check($data['token'], $row->token)) {
            $this->addError('token', 'رمز غير صالح أو منتهي.');

            return;
        }

        $client = Client::query()
            ->where('phone', trim($data['phone']))
            ->first();

        if (! $client) {
            $this->addError('phone', 'الحساب غير موجود.');

            return;
        }

        $client->password = $data['password'];
        $client->save();

        DB::table('client_password_reset_tokens')
            ->where('phone', trim($data['phone']))
            ->delete();

        session()->flash('success', 'تم تحديث كلمة المرور بنجاح.');
        $this->redirect(route('client.login'), navigate: true);
    }

    public function render()
    {
        return view('livewire.auth.reset-password-form')->layout('layouts.master');
    }
}
