<?php

namespace App\Livewire\Auth;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class LoginForm extends Component
{
    public string $phone = '';

    public string $password = '';

    public bool $remember = true;

    private function normalizePhone(string $input): ?string
    {
        $p = preg_replace('/\D+/', '', $input) ?? '';
        if ($p === '') {
            return null;
        }

        // 11 رقم محلي يبدأ بـ 07
        if (preg_match('/^07\d{9}$/', $p)) {
            return '00964'.substr($p, 1); // احذف 0 الأولى
        }

        // 14 رقم دولي يبدأ بـ 00964
        if (preg_match('/^00964\d{9}$/', $p)) {
            return $p;
        }

        return null;
    }

    public function login(): void
    {
        $this->validate([
            'phone' => ['required'],
            'password' => ['required', 'string'],
        ], [
            'phone.required' => 'رقم الهاتف مطلوب.',
            'password.required' => 'كلمة المرور مطلوبة.',
        ]);

        $normalized = $this->normalizePhone($this->phone);

        if (! $normalized) {
            $this->addError('phone', 'رقم الهاتف يجب أن يكون 11 رقم يبدأ بـ 07 أو 14 رقم يبدأ بـ 00964.');
            $this->dispatch('auth-error');

            return;
        }

        $ok = Auth::guard('client')->attempt(
            ['phone' => $normalized, 'password' => $this->password, 'is_active' => 1],
            $this->remember
        );

        if (! $ok) {
            $this->addError('phone', 'بيانات الدخول غير صحيحة.');
            $this->dispatch('auth-error');

            return;
        }

        session()->regenerate();
        $this->redirect(route('home'), navigate: true);
    }

    public function render()
    {
        return view('livewire.auth.login-form')->layout('layouts.master');
    }
}
