<?php

namespace App\Livewire\Auth;

use App\Models\Client;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Livewire\Component;

class ForgotPasswordForm extends Component
{
    public string $phone = '';

    public function sendResetLink(): void
    {
        $data = $this->validate([
            'phone' => ['required', 'string', 'min:6'],
        ]);

        $phone = trim($data['phone']);

        $client = Client::query()
            ->where('phone', $phone)
            ->where('is_active', true)
            ->first();

        // لا نكشف إن كان الرقم موجودًا أو لا (سلوك أمني)
        if (! $client) {
            session()->flash('success', 'إذا كان الرقم صحيحًا فستصلك رسالة إعادة تعيين كلمة المرور.');

            return;
        }

        $plainToken = Str::random(64);

        DB::table('client_password_reset_tokens')->updateOrInsert(
            ['phone' => $phone],
            [
                'token' => Hash::make($plainToken),
                'created_at' => now(),
            ]
        );

        // لاحقًا: إرسال SMS
        session()->flash('success', 'تم إنشاء طلب إعادة تعيين كلمة المرور.');

        // للتجربة محليًا فقط
        if (app()->environment('local')) {
            session()->flash('debug_reset_link', route('client.password.reset', ['token' => $plainToken]).'?phone='.urlencode($phone));
        }

        $this->reset('phone');
    }

    public function render()
    {
        return view('livewire.auth.forgot-password-form')->layout('layouts.guest');
    }
}
