<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TrackClientSession
{
    public function handle(Request $request, Closure $next)
    {
        // نتأكد يوجد session
        if ($request->hasSession()) {
            $session = $request->session();
            $sessionId = (string) $session->getId();

            $clientId = Auth::guard('client')->check()
                ? (int) Auth::guard('client')->id()
                : null;

            $now = now();

            DB::table('client_sessions')->updateOrInsert(
                ['id' => $sessionId],
                [
                    'client_id' => $clientId,
                    'ip_address' => (string) $request->ip(),
                    'user_agent' => (string) $request->userAgent(),
                    'payload' => null, // اختياري
                    'last_activity' => (int) $now->timestamp,
                    'updated_at' => $now,
                    // created_at لا نضعه هنا حتى لا يتغير مع التحديث
                ]
            );

            // إن لم يكن موجودًا أضف created_at مرة واحدة
            // (حل سريع بدون استعلام إضافي: حاول Insert تجاهل عند التكرار)
            // لكن بما أننا استخدمنا updateOrInsert، نضمن created_at عبر استعلام ثانٍ خفيف:
            DB::table('client_sessions')
                ->where('id', $sessionId)
                ->whereNull('created_at')
                ->update(['created_at' => $now]);
        }

        return $next($request);
    }
}
