<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Services\Orders\OrderInvoiceService;

class OrderPrintController extends Controller
{
    public function __construct(
        protected OrderInvoiceService $invoiceService
    ) {}

    /**
     * طباعة فاتورة الطلب
     */
    public function print(Order $order)
    {
        $data = $this->invoiceService->getOrderPrintData($order);

        return view('orders.print', $data);
    }

    /**
     * تحميل فاتورة الطلب كـ PDF
     */
    public function pdf(Order $order)
    {
        $data = $this->invoiceService->getOrderPrintData($order);

        // يمكن إضافة مكتبة PDF هنا مثل dompdf أو snappy
        // مؤقتاً سنعيد التوجيه إلى صفحة الطباعة
        return view('orders.print', $data);
    }
}
