<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\View\View;

class HomeController extends Controller
{
    /**
     * Display the home page.
     */
    public function index(): View
    {
        // Get active main categories (parent_id is null) with product count
        // Limit to 4 categories for Bento Grid layout
        $categories = Category::query()
            ->where('is_active', true)
            ->whereNull('parent_id')
            ->withCount(['products' => fn ($q) => $q->active()])
            ->having('products_count', '>', 0)
            ->orderBy('name')
            ->limit(4)
            ->get();

        // Get latest 8 products
        $latestProducts = Product::query()
            ->active()
            ->with(['category', 'brand', 'defaultVariant', 'variants'])
            ->latest('id')
            ->limit(8)
            ->get();

        // Get best selling products (top 8) - using random for now
        // TODO: Add order_items relationship when Order system is implemented
        $bestSellingProducts = Product::query()
            ->active()
            ->with(['category', 'brand', 'defaultVariant', 'variants'])
            ->inRandomOrder()
            ->limit(8)
            ->get();

        // Get featured/special offer products (products with any variant available)
        $featuredProducts = Product::query()
            ->active()
            ->with(['category', 'brand', 'defaultVariant', 'variants'])
            ->whereHas('variants', fn ($q) => $q->where('is_active', true))
            ->inRandomOrder()
            ->limit(8)
            ->get();

        return view('home', compact('categories', 'latestProducts', 'bestSellingProducts', 'featuredProducts'));
    }
}
