<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\View\View;

class CategoryController extends Controller
{
    /**
     * Display the category page with subcategories and products.
     */
    public function show(Category $category): View
    {
        // Ensure category is active
        abort_unless($category->is_active, 404);

        // Load children categories with product count
        $subcategories = $category->children()
            ->active()
            ->withCount(['products' => fn ($q) => $q->active()])
            ->orderBy('name')
            ->get();

        // Get breadcrumbs (parent hierarchy)
        $breadcrumbs = $this->getBreadcrumbs($category);

        return view('store.category', compact('category', 'subcategories', 'breadcrumbs'));
    }

    /**
     * Get category breadcrumbs hierarchy.
     */
    private function getBreadcrumbs(Category $category): array
    {
        $breadcrumbs = [];
        $current = $category;

        while ($current) {
            array_unshift($breadcrumbs, $current);
            $current = $current->parent;
        }

        return $breadcrumbs;
    }
}
