<?php

use App\Models\Vault;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;

if (! function_exists('user_info')) {
    /**
     * Get current authenticated user or a specific column.
     */
    function user_info(?string $column = null, $default = null)
    {
        $user = Auth::user();

        if (! $user) {
            return $default;
        }

        return is_null($column)
            ? $user
            : data_get($user, $column, $default); // يدعم العلاقات مثل branch.name
    }
}

if (! function_exists('current_warehouse')) {
    function current_warehouse(): ?Warehouse
    {
        $branchId = (int) (user_info('branch_id') ?? 0);

        return $branchId
            ? Warehouse::forBranch($branchId)->active()->orderBy('id')->first()
            : null;
    }
}

if (! function_exists('current_vault')) {
    function current_vault(): ?Vault
    {
        $branchId = (int) (user_info('branch_id') ?? 0);

        return $branchId
            ? Vault::forBranch($branchId) // ترجّع أول خزنة نشطة للفرع
            : null;
    }
}
