<?php

namespace App\Helper;

class PriceHelper
{
    /**
     * تنسيق المبلغ للأرقام الكبيرة:
     * - يقبل int|string|null
     * - يحوّل أي نص إلى أرقام فقط ثم ينسّقها: 350000 => "350,000"
     */
    public static function format(null|string|int $value): string
    {
        if ($value === null || $value === '') {
            return '';
        }

        // إزالة أي فواصل/أحرف غير رقمية ثم التحويل إلى int
        $n = (int) preg_replace('/[^\d]/', '', (string) $value);

        return number_format($n, 0);
    }

    /**
     * تفريغ النص (مثل "350,000") إلى عدد صحيح 350000
     */
    public static function dehydrate(null|string|int $value): ?int
    {
        if ($value === null || $value === '') return null;
        $clean = preg_replace('/[^\d]/', '', (string) $value);
        return $clean === '' ? null : (int) $clean;
    }

    /**
     * تدوير لأقرب مضاعف 250
     */
    public static function toStep250(null|string|int $value): ?int
    {
        if ($value === null || $value === '') return null;
        $int = is_int($value) ? $value : (int) preg_replace('/[^\d]/', '', (string) $value);
        return (int) (round($int / 250) * 250);
    }
}
