<?php

namespace App\Filament\Resources\VaultTransactions;

use BackedEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use App\Models\VaultTransaction;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\VaultTransactions\Pages\ListVaultTransactions;
use App\Filament\Resources\VaultTransactions\Schemas\VaultTransactionForm;
use App\Filament\Resources\VaultTransactions\Tables\VaultTransactionsTable;

class VaultTransactionResource extends Resource
{
    protected static ?string $model = VaultTransaction::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::Banknotes;
    protected static string|\UnitEnum|null $navigationGroup = NavGroups::Finance;
    protected static ?string $navigationLabel               = 'الخزنة';
    protected static ?string $modelLabel                    = 'مبلغ';
    protected static ?string $pluralLabel                   = 'الخزنة';
    protected static ?string $recordTitleAttribute          = 'vault_id';
    protected static ?string $slug                          = 'vault';
    protected static ?int $navigationSort                   = 33;

    public static function form(Schema $schema): Schema
    {
        return VaultTransactionForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return VaultTransactionsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListVaultTransactions::route('/'),
            // 'create' => CreateVaultTransaction::route('/create'),
            // 'edit'   => EditVaultTransaction::route('/{record}/edit'),
        ];
    }
}
