<?php

namespace App\Filament\Resources\VaultTransactions\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;

class VaultTransactionForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            TextInput::make('amount')
                ->label('المبلغ')
                ->required()
                ->formatStateUsing(fn($state) => $state !== null ? number_format((int) $state) : '')
                ->dehydrateStateUsing(fn($state) => (int) preg_replace('/[^\d]/', '', (string) $state))
                ->extraInputAttributes([
                    'inputmode' => 'numeric',
                    // nowdoc لتجنّب تفسير $el من PHP
                    'x-data' => '{}',
                    'x-on:input' => <<<'JS'
                        let raw = $el.value.replace(/[^\d]/g, '');
                        $el.value = raw ? new Intl.NumberFormat('en-US').format(raw) : '';
                    JS,
                ])
                ->helperText('أدخل المبلغ المراد إيداعه في الخزنة.')
                ->columnSpanFull(),
        ]);
    }
}
