<?php

namespace App\Filament\Resources\VaultTransactions\Pages;

use App\Models\VaultTransaction;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Resources\VaultTransactions\VaultTransactionResource;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Validation\ValidationException;

class CreateVaultTransaction extends CreateRecord
{
    protected static string $resource = VaultTransactionResource::class;

    protected function handleRecordCreation(array $data): Model
    {
        // يدعم amount ثم balance كتوافق خلفي
        $amountRaw = $data['amount'] ?? $data['balance'] ?? 0;
        $amount    = (int) preg_replace('/[^\d]/', '', (string) $amountRaw);
        $desc      = $data['description'] ?? null;
        $type      = (int) ($data['transaction_type'] ?? VaultTransaction::TYPE_DEPOSIT);

        if ($amount <= 0) {
            throw ValidationException::withMessages([
                'amount' => 'المبلغ يجب أن يكون رقمًا موجبًا.',
            ]);
        }

        $vault = current_vault();
        $user  = user_info(); // 👈 موديل المستخدم كمصدر

        try {
            return match ($type) {
                VaultTransaction::TYPE_WITHDRAW => $vault->withdraw($user, $amount, $desc, $user->id),
                default                         => $vault->deposit($user, $amount, $desc, $user->id),
            };
        } catch (\RuntimeException $e) {
            throw ValidationException::withMessages([
                'amount' => $e->getMessage(),
            ]);
        }
    }

    protected function getCreatedNotificationTitle(): ?string
    {
        return 'تم تسجيل الحركة على الخزنة';
    }

    protected function getRedirectUrl(): string
    {
        return static::$resource::getUrl('index');
    }
}
