<?php

namespace App\Filament\Resources\Users\Pages;

use App\Enums\RoleEnum;
use App\Filament\Resources\Users\UserResource;
use App\Models\User;
use Filament\Actions\DeleteAction;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;

class EditUser extends EditRecord
{
    protected static string $resource = UserResource::class;

    protected function afterSave(): void
    {
        /** @var \App\Models\User $user */
        $user = $this->record;

        $roles = (array) ($this->form->getState()['roles'] ?? []);

        // غير الأدمن لا يقدر يمنح admin
        if (! user_info()?->hasRole(RoleEnum::admin->value)) {
            $roles = array_values(array_filter($roles, fn ($r) => $r !== RoleEnum::admin->value));
        }

        $user->syncRoles($roles);
    }

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make()
                ->before(function () {
                    $actor = user_info();

                    // منع غير الأدمن من حذف مستخدم أدمن
                    if (! $actor?->hasRole(RoleEnum::admin->value) && $this->record->hasRole(RoleEnum::admin->value)) {
                        abort(403, 'غير مصرح بحذف مستخدم مسؤول.');
                    }

                    // منع حذف آخر أدمن في النظام
                    if ($this->record->hasRole(RoleEnum::admin->value)) {
                        $otherAdmins = User::role(RoleEnum::admin->value)
                            ->where('id', '!=', $this->record->id)
                            ->count();

                        if ($otherAdmins === 0) {
                            Notification::make()
                                ->danger()
                                ->title('لا يمكن حذف آخر مسؤول في النظام')
                                ->send();

                            $this->halt();
                        }
                    }
                }),
        ];
    }
}
