<?php

namespace App\Filament\Resources\Users\Pages;

use App\Enums\RoleEnum;
use App\Filament\Resources\Users\UserResource;
use Filament\Resources\Pages\CreateRecord;

class CreateUser extends CreateRecord
{
    protected static string $resource = UserResource::class;

    protected function afterCreate(): void
    {
        /** @var \App\Models\User $user */
        $user = $this->record;

        // roles موجودة بالـ form state حتى لو dehydrated(false)
        $roles = (array) ($this->form->getState()['roles'] ?? []);

        // غير الأدمن لا يقدر يمنح admin
        if (! user_info()?->hasRole(RoleEnum::admin->value)) {
            $roles = array_values(array_filter($roles, fn ($r) => $r !== RoleEnum::admin->value));
        }

        $user->syncRoles($roles);
    }
}
