<?php

namespace App\Filament\Resources\Suppliers\Tables;

use App\Models\Branch;
use Filament\Tables\Table;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Actions\ActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ViewColumn;
use Filament\Tables\Filters\SelectFilter;

class SuppliersTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('branch.name')
                    ->label('الفرع')
                    ->visible(fn() => auth()->user()->hasRole('admin'))
                    ->searchable(),
                ViewColumn::make('name')
                    ->label('المورد')
                    ->sortable('name')
                    ->searchable()
                    ->view('filament.tables.columns.supplier-main'),
                TextColumn::make('company')
                    ->label(' الشركة')
                    ->searchable(),
                TextColumn::make('address')
                    ->label('العنوان')
                    ->sortable()
                    ->searchable(),
                IconColumn::make('is_active')
                    ->label('الحالة')
                    ->boolean(),
                TextColumn::make('created_at')
                    ->label('تم الإنشاء في')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->label('تم التحديث في')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('branch_id')
                    ->label('الفرع')
                    ->searchable()
                    ->visible(fn() => auth()->user()->hasRole('admin'))
                    ->options(Branch::pluck('name', 'id')),
                SelectFilter::make('is_active')
                    ->label('الحالة')
                    ->options([
                        true    => 'نشط',
                        false   => 'متوقف',
                    ]),
            ])
            ->recordActions([
                ActionGroup::make([
                    ViewAction::make()
                        ->label('عرض'),
                    DeleteAction::make()
                        ->label('حذف'),
                    EditAction::make()
                        ->label('تعديل'),
                ])
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
