<?php

namespace App\Filament\Resources\Suppliers;

use UnitEnum;
use BackedEnum;
use App\Models\Supplier;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Suppliers\Pages\EditSupplier;
use App\Filament\Resources\Suppliers\Pages\ViewSupplier;
use App\Filament\Resources\Suppliers\Pages\ListSuppliers;
use App\Filament\Resources\Suppliers\Pages\CreateSupplier;
use App\Filament\Resources\Suppliers\Schemas\SupplierForm;
use App\Filament\Resources\Suppliers\Schemas\SupplierInfolist;
use App\Filament\Resources\Suppliers\Tables\SuppliersTable;

class SupplierResource extends Resource
{
    protected static ?string $model = Supplier::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::User;
    protected static ?string $navigationLabel               = 'الموردين';
    protected static ?string $modelLabel                    = 'مورد';
    protected static ?string $pluralModelLabel              = 'الموردين';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::PURCHASES;
    protected static ?int $navigationSort                   = 70;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function form(Schema $schema): Schema
    {
        return SupplierForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return SupplierInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return SuppliersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListSuppliers::route('/'),
            'create' => CreateSupplier::route('/create'),
            'view'   => ViewSupplier::route('/{record}'),
            'edit'   => EditSupplier::route('/{record}/edit'),
        ];
    }
}
