<?php

namespace App\Filament\Resources\Suppliers\Schemas;

use App\Models\Supplier;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class SupplierInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('name')
                    ->label('اسم المورد'),
                TextEntry::make('phone')
                    ->label('رقم الهاتف')
                    ->placeholder('-'),
                TextEntry::make('email')
                    ->label('البريد الإلكتروني')
                    ->placeholder('-'),
                TextEntry::make('address')
                    ->label('العنوان')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('tax_number')
                    ->label('الرقم الضريبي')
                    ->placeholder('-'),
                TextEntry::make('commercial_register')
                    ->label('السجل التجاري')
                    ->placeholder('-'),
                TextEntry::make('contact_person')
                    ->label('الشخص المسؤول')
                    ->placeholder('-'),
                TextEntry::make('contact_person_phone')
                    ->label('هاتف المسؤول')
                    ->placeholder('-'),
                TextEntry::make('notes')
                    ->label('ملاحظات')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime('Y-m-d H:i')
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->label('تاريخ آخر تحديث')
                    ->dateTime('Y-m-d H:i')
                    ->placeholder('-'),
            ]);
    }
}
