<?php

namespace App\Filament\Resources\Suppliers\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class SupplierForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('branch_id')
                    ->label('الفروع')
                    ->relationship('branch', 'name')
                    ->preload()
                    ->searchable()
                    ->visible(fn() => auth()->user()->hasRole('admin'))
                    ->required(),
                TextInput::make('name')
                    ->label('اسم المورد')
                    ->placeholder('أدخل اسم المورد'),
                TextInput::make('company')
                    ->label(' الشركة')
                    ->placeholder('أدخل اسم الشركة'),
                TextInput::make('phone')
                    ->label('رقم الهاتف')
                    ->tel()
                    ->maxLength(11)
                    ->extraInputAttributes([
                        'dir' => 'ltr',
                        'class' => 'text-right',
                    ])
                    ->placeholder('أدخل رقم الهاتف'),
                TextInput::make('address')
                    ->label('العنوان')
                    ->placeholder('أدخل العنوان')
                    ->required(),
                Toggle::make('is_active')
                    ->label('الحالة')
                    ->visibleOn('edit')
                    ->required(),
            ]);
    }
}
